unit MainUnit;

//    TPen.
//    ( Pen.Style )
//     ( Pen.Mode ).

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Spin, ExtCtrls;

type
  TForm1 = class(TForm)
    ColorDialog1: TColorDialog;
    SpinEdit1: TSpinEdit;
    Bevel1: TBevel;
    Label1: TLabel;
    LabelTitle: TLabel;
    CmbBoxMode: TComboBox;
    Label2: TLabel;
    Bevel2: TBevel;
    Label3: TLabel;
    Button2: TButton;
    Button3: TButton;
    stxtColor: TStaticText;
    stxtBackColor: TStaticText;
    Label4: TLabel;
    Label5: TLabel;
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CmbBoxModeClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure stxtBackColorClick(Sender: TObject);
    procedure stxtColorClick(Sender: TObject);
  private
    { Private declarations }
    procedure PaintLines(RqClear : boolean; RqMode : TPenMode);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//     Pen.Mode
type TPmItem = record
   PmDt  : TPenMode;
   PmNm  : string;
   Desc  : string;
end;

//    Pen.Mode
const ArrPmItem : array [0..15] of TPmItem =
(
  ( PmDt : pmBlack;        PmNm : 'pmBlack'; Desc : 'Always black' ),
  ( PmDt : pmWhite;        PmNm : 'pmWhite'; Desc : 'Always white' ),
  ( PmDt : pmNop;          PmNm : 'pmNop';   Desc : 'Unchanged' ),
  ( PmDt : pmNot;          PmNm : 'pmNot';   Desc : 'Inverse of canvas background color' ),
  ( PmDt : pmCopy;         PmNm : 'pmCopy';  Desc : 'Pen color specified in Color property' ),
  ( PmDt : pmNotCopy;      PmNm : 'pmNotCopy'; Desc : 'Inverse of pen color' ),
  ( PmDt : pmMergePenNot;  PmNm : 'pmMergePenNot'; Desc : 'Combination of pen color and inverse of canvas background' ),
  ( PmDt : pmMaskPenNot;   PmNm : 'pmMaskPenNot';  Desc : 'Combination of colors common to both pen and inverse of canvas background' ),
  ( PmDt : pmMergeNotPen;  PmNm : 'pmMergeNotPen'; Desc : 'Combination of canvas background color and inverse of pen color' ),
  ( PmDt : pmMaskNotPen;   PmNm : 'pmMaskNotPen';  Desc : 'Combination of colors common to both canvas background and inverse of pen' ),
  ( PmDt : pmMerge;        PmNm : 'pmMerge';    Desc : 'Combination of pen color and canvas background color' ),
  ( PmDt : pmNotMerge;     PmNm : 'pmNotMerge'; Desc : 'Inverse of pmMerge: combination of pen color and canvas background color' ),
  ( PmDt : pmMask;         PmNm : 'pmMask';     Desc : 'Combination of colors common to both pen and canvas background' ),
  ( PmDt : pmNotMask;      PmNm : 'pmNotMask';  Desc : 'Inverse of pmMask: combination of colors common to both pen and canvas background' ),
  ( PmDt : pmXor;          PmNm : 'pmXor';      Desc : 'Combination of colors in either pen or canvas background, but not both' ),
  ( PmDt : pmNotXor;       PmNm : 'pmNotXor';   Desc : 'Inverse of pmXor: combination of colors in either pen or canvas background, but not both' )
);

//     Pen.Style
type TPsItem = record
   PsDt : TPenStyle;    // ,  
   PsNm : string;       //   
end;

//    Pen.Style
const ArrPsItem : array [0..6] of TPsItem =
(
  ( PsDt : psSolid;       PsNm : 'psSolid'       ),
  ( PsDt : psClear;       PsNm : 'psClear'       ),
  ( PsDt : psDash;        PsNm : 'psDash'        ),
  ( PsDt : psDot;         PsNm : 'psDot'         ),
  ( PsDt : psDashDot;     PsNm : 'psDashDot'     ),
  ( PsDt : psDashDotDot;  PsNm : 'psDashDotDot'  ),
  ( PsDt : psInsideFrame; PsNm : 'psInsideFrame' )   //  
);

//   
var CurrentMode  : TPenMode;

//    
procedure TForm1.PaintLines(RqClear : boolean; RqMode : TPenMode);
const XB = 20;     //     
      YS = 40;     //    Y
var   Ind, XE, Y : integer;
begin
  XE := ClientWidth - XB;
  Y := YS;
  if RqClear
  then begin
      // 
      Canvas.Pen.Color   :=  stxtBackColor.Color;
      Canvas.Pen.Style   :=  psSolid;
      Canvas.Pen.Mode    :=  pmCopy;
      Canvas.Brush.Color :=  stxtBackColor.Color;
      Canvas.Brush.Style :=  bsSolid;
      Canvas.Rectangle(0, YS - 8, ClientWidth, Bevel1.Top - 8 );
  end
  else begin
     //         
     Canvas.Pen.Color :=  stxtColor.Color;
     Canvas.Pen.Mode  := RqMode;
     for Ind := 0 to High(ArrPsItem)
     do begin
        Canvas.Pen.Style := ArrPsItem[Ind].PsDt;
        Canvas.MoveTo( XB, Y);
        Canvas.LineTo( XE, Y);
        Canvas.TextOut ( XB, Y + 6, ArrPsItem[Ind].PsNm);
        Y := Y + YS;
     end;
  end;
end;

//    
procedure TForm1.stxtBackColorClick(Sender: TObject);
begin
   if ColorDialog1.Execute
   then begin
     stxtBackColor.Color := ColorDialog1.Color;
     Self.Repaint;  //     (  FormPaint(Self))
   end;
end;

//    
procedure TForm1.stxtColorClick(Sender: TObject);
begin
   if ColorDialog1.Execute
   then begin
      stxtColor.Color := ColorDialog1.Color;
      PaintLines(False, CurrentMode);
   end;
end;

//    
procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  Canvas.Pen.Width:= SpinEdit1.Value;
  Self.Repaint;  //     (  FormPaint(Self))
end;

//    
procedure TForm1.CmbBoxModeClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxMode.ItemIndex;
  CurrentMode := ArrPmItem[Ind].PmDt;
  Label2.Caption := ' : ' + ArrPmItem[CmbBoxMode.ItemIndex].Desc;
end;

//     
procedure TForm1.Button2Click(Sender: TObject);
begin
   PaintLines(False, CurrentMode);
end;

//    
procedure TForm1.Button3Click(Sender: TObject);
begin
  PaintLines(True, pmCopy);
end;

//  :     
procedure TForm1.FormPaint(Sender: TObject);
begin
   PaintLines(True, pmCopy);
   PaintLines(False, CurrentMode);
end;

//     
procedure TForm1.FormCreate(Sender: TObject);
var Ind : integer;
begin
   CmbBoxMode.Clear;
   for Ind := 0 to High(ArrPmItem)
   do CmbBoxMode.Items.Add(ArrPmItem[Ind].PmNm);
   //    
   Ind := 4; // pmCopy
   CurrentMode := ArrPmItem[Ind].PmDt;
   CmbBoxMode.ItemIndex := Ind;
   Label2.Caption := ' : ' + ArrPmItem[Ind].Desc;
   stxtColor.Color := RGB(128,240,240);
end;


end.
